/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.tileentity;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModBlockEntities;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.tileentity.InventoryTileEntity;
import dev.toma.gunsrpg.util.locate.SlotInventoryIterator;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class RepairStationTileEntity
extends InventoryTileEntity {
    public static final int SLOT_INPUT = 0;
    public static final int[] STORAGE = new int[]{1, 2, 3};

    protected RepairStationTileEntity(TileEntityType<? extends RepairStationTileEntity> type) {
        super(type);
    }

    public RepairStationTileEntity() {
        this((TileEntityType<? extends RepairStationTileEntity>)((TileEntityType)ModBlockEntities.REPAIR_STATION.get()));
    }

    @Override
    public IItemHandlerModifiable createInventory() {
        return new ItemStackHandler(5);
    }

    public void repair(PlayerEntity player) {
        ItemStack weapon = this.itemHandler.getStackInSlot(0);
        GunItem item = (GunItem)weapon.func_77973_b();
        float durability = item.getDurabilityLimit(weapon);
        IAttributeProvider provider = PlayerData.getUnsafe(player).getAttributes();
        float durabilityMultiplier = provider.getAttribute(Attribs.REPAIR_PENALTY).floatValue();
        float newDurability = durabilityMultiplier * durability;
        item.setDurabilityLimit(weapon, newDurability);
        int itemDurability = (int)((float)weapon.func_77958_k() * newDurability);
        weapon.func_196085_b(weapon.func_77958_k() - itemDurability);
        ItemStack stack = this.getRepairKit();
        int repairKitDmg = stack.func_77952_i();
        stack.func_196085_b(repairKitDmg + 1);
        if (1 + repairKitDmg == stack.func_77958_k()) {
            stack.func_190918_g(1);
        }
        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.REPAIR, SoundCategory.MASTER, 1.0f, 1.0f);
    }

    public boolean canRepair() {
        ItemStack repairKit = this.getRepairKit();
        return this.isWeaponRepairable(this.itemHandler.getStackInSlot(0)) && !repairKit.func_190926_b();
    }

    private boolean isWeaponRepairable(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        GunItem item = (GunItem)stack.func_77973_b();
        float repairDurability = item.getDurabilityLimit(stack);
        int damage = stack.func_77952_i();
        int limit = (int)((float)stack.func_77958_k() * repairDurability);
        return stack.func_77958_k() - damage < limit && repairDurability > 0.1f;
    }

    private ItemStack getRepairKit() {
        return ItemLocator.INSTANCE.findFirst(this.itemHandler, new SlotInventoryIterator<IItemHandlerModifiable>(STORAGE, IItemHandler::getStackInSlot), ItemLocator.notDestroyedItem());
    }
}

